﻿<?xml version="1.0" encoding="utf-8"?>

<shader rid="LSHD">
<!--Raw text data for the shaders-->
  <source type="vertex" rid="file://lzsystem/shaders/generic/fullscreenQuad.glsl"/>
  <source type="fragment">
    <![CDATA[
#version 430

//Include the global transforms block
#pragma lz append("lzsystem/shaders/generic/globalTransforms.glsl")
#pragma lz append("lzsystem/shaders/postprocess/color.glsl")
#line 13


vec3 Linear(vec3 L, float exposure) {
	return pow(L * exposure, vec3(1/2.2));
}

vec3 SimpleReinhard(vec3 L, float exposure) {
	L = L * exposure;
	return pow(L / (L+vec3(1)), vec3(1/2.2));
}

vec3 GammaCompress(vec3 L, float exposure, float gamma) {
	return exposure * pow(L,vec3(gamma));
}

float Reinhard(float lumLocal, float lumMax, float lumAvg, float exposure) {
	//Tone map the luminance
	float Lwhite = lumMax * lumMax;
	float L = (exposure * lumLocal) / (lumAvg);
	float Ld = (L * (1.0 + L / Lwhite)) / (1.0 + L);

	return Ld;
}

vec3 Reinhard(vec3 color, float lumLocal, float lumMax, float lumAvg, float exposure) {
	float Ld = Reinhard(lumLocal, lumMax, lumAvg, exposure);
	color = RGB2xyY(color);
	color.z *= Ld;
	return xyY2RGB(color);
}

vec3 Exponential(vec3 L, float exposure) {
	L = L * exposure;
	L.r = L.r < 1.413 ? pow(L.r * 0.38317, 1.0 / 2.2) : 1.0 - exp(-L.r);
	L.g = L.g < 1.413 ? pow(L.g * 0.38317, 1.0 / 2.2) : 1.0 - exp(-L.g);
	L.b = L.b < 1.413 ? pow(L.b * 0.38317, 1.0 / 2.2) : 1.0 - exp(-L.b);
	return L;
}

//Filmic tone mapping as explained in http://filmicgames.com/archives/75 and http://www.slideshare.net/ozlael/hable-john-uncharted2-hdr-lighting
vec3 Filmic(vec3 L, float exposure) {
	L = max(vec3(0.0), L*exposure - vec3(0.004));
	return (L*(6.2*L+vec3(0.5)))/(L*(6.2*L+vec3(1.7))+vec3(0.06));
}

//Filmic tone mapping with linear white adjustment integrated
vec3 Filmic(vec3 L, float exposure, vec3 linearWhite) {
	return Filmic(L, exposure) / Filmic(linearWhite, exposure);
}


vec3 FilmicFunction(vec3 L,
				  float shoulderStr,
				  float linearStr,
				  float linearAngle,
				  float toeStr,
				  float toeNum,
				  float toeDenom  //toeNum / toeDenum = toeAngle
) {
	return (L*(shoulderStr*L+vec3(linearAngle*linearStr)))/(L*(shoulderStr*L+vec3(linearStr)+toeStr*toeDenom)) - vec3(toeNum/toeDenom);
}

vec3 FilmicCustom(vec3 L, float exposure,
				  float shoulderStr, //Similar effect to exposure
				  float linearStr,   //Higher values lower constrast, although the effect is tied to linearAngle directly
				  float linearAngle, //Lower values burn colors and increase contrast
				  float toeStr,      //Higher values increase contrast and burn in
				  float toeNum,      //Toe angle controls the darker color contrast
				  float toeDenom,    //toeNum / toeDenum = toeAngle
				  vec3 linearWhite
) {
	L = max(vec3(0.0), L*exposure);
	return pow(FilmicFunction(L, shoulderStr, linearStr, linearAngle, toeStr, toeNum, toeDenom) / FilmicFunction(linearWhite, shoulderStr, linearStr, linearAngle, toeStr, toeNum, toeDenom), vec3(1.0/2.2));
}

vec3 U2(vec3 L, float exposure) {
	return FilmicCustom(L, exposure,
		0.15,
		0.50,
		0.07,
		0.20,
		0.02,
		0.30,
		vec3(11.2));
}

//The exposure
uniform float exposure;

//Uniforms for the custom filmic tone map
layout(std140, binding = 2) uniform filmicSettings {
	vec4 linearWhite;  //Highest white color
	float shoulderStr; //Similar effect to exposure
	float linearStr;   //Higher values lower constrast, although the effect is tied to linearAngle directly
	float linearAngle; //Lower values burn colors and increase contrast
	float toeStr;      //Higher values increase contrast and burn in
	float toeNum;      //Toe angle controls the darker color contrast
	float toeDenom;    //toeNum / toeDenum = toeAngle
};

//Uses the uniform buffer data to tone map with the filmic tone mapper
vec3 FilmicExt(vec3 L) {
	return FilmicCustom(L, exposure, 
		shoulderStr,
		linearStr,
		linearAngle,
		toeStr,
		toeNum,
		toeDenom,
		linearWhite.rgb
	);
}

//The texture used
layout(binding = 0) uniform sampler2D img;
layout(binding = 1) uniform sampler2D lum;

//The input from the VS
in VSOut {
	vec2 uv;
} fsinput;

layout(location = 0) out vec4 fragment;


void main() {
	vec4 texel = textureLod(img, fsinput.uv,0);
	fragment.rgb = FilmicExt(texel.rgb);
}

    ]]>
  </source>
  
</shader>

